rm()

######################################################################################
##############################     DGP      ###########################################
#######    SV:    dx_t=(r-delta)*x_t*dt+(\sqrt(v_t))*x_t*dW_t, dv_t=kappa*(theta-v_t)*dt+sigma*\sqrt(v_t)*dU_t  under risk-neutral measure;
#######    EO: European option price;
#######    AO: American option price; consider the price based on Binomial method as the true price;
#######    EEP: early exercise premium; EEP=AO-EO;
#######    
#########################################################################################

setwd(dirname(rstudioapi::getSourceEditorContext()$path)) #set working directory to source file location

library(plotly)
library(RQuantLib)
require(orthopolynom) #orthogonal polynomial package
require(parallel)
require("quadprog")   #quadratic programming package for estimation
source(file = file.path(dirname(getwd()), "functions", "kfold.R"))            #for cross validation
source(file = file.path(dirname(getwd()), "functions", "CVJ.R"))              #cross validation to choose truncation order
source(file = file.path(dirname(getwd()), "functions",  "RND.r"))             #calculate the RND based on the European option price
source(file = file.path(dirname(getwd()), "functions",  "eep_hst.r"))         #compute the early exercise premium (eep) for a given exercise boundary and transition density  
source(file = file.path(dirname(getwd()), "functions", "hst_eo_app.r"))       #compute the European option price
source(file = file.path(dirname(getwd()), "functions", "EEPC.R"))             #EEPC function

require(nleqslv)
####################################################################################
library(R.matlab)


####################################################################################################################
### choose time to maturity ###
t<-365/365
time<-t
ObsErr <- 0.00

####################################   1-year maturity   ###########################################
  
HST <- readMat(file.path(dirname(getwd()), "data", "SVCJ_spd_expansion_annual_1y_simbyEuler.mat"))
den<- readMat(file.path(dirname(getwd()), "data", "SVCJ_den_expansion_annual_1y_simbyEuler.mat"))
  
S0  = 1300;  #Initial price
r    = .05;  #Interest rate
delta    = r/2;  #dividend yield
sigma = 0.1557;  # implied vol, not needed, placeholder
M<-10
Delta<-t/M
  
K1 = seq(900,1000,25);
K2 = seq(1000,1100,20);
K3 = seq(1100,1200,10);
K4 = seq(1200,1400,5);
K5 = seq(1400,1500,10);
K6 = seq(1500,1600,20);
K7 = seq(1600,1700,25);
Kvec=c(K1,K2,K3,K4,K5,K6,K7);
K=unique(Kvec);
  
ncall<-length(K)
tol<-1 #for finding the EEP
ptol<-0.05*sqrt(t)
bd<-10  #max 10 dollars  

AO_P<-HST$prices.put
AO_C<-HST$prices.call
EO_P<-HST$prices.eo.put
EO_C<-HST$prices.eo.call
EEP_P<-AO_P-EO_P
EEP_C<-AO_C-EO_C

Put<-plot_ly(x=~K,y=~EO_P,type='scatter',mode='lines',name="Price of European Put Option")%>%
  add_lines(x=~K,y=~AO_P,type='scatter',mode='lines',name="Price of American Put Option")%>%
  add_lines(x=~K,y=~EEP_P,type='scatter',mode='lines',name="Early Exercise Premium")%>%
  layout(xaxis=list(title="Strike Price"),
         yaxis=list(title="Price"))

Call<-plot_ly(x=~K,y=~EO_C,type='scatter',mode='lines',name="Price of European Call Option")%>%
  add_lines(x=~K,y=~AO_C,type='scatter',mode='lines',name="Price of American Call Option")%>%
  add_lines(x=~K,y=~EEP_C,type='scatter',mode='lines',name="Early Exercise Premium")%>%
  layout(xaxis=list(title="Strike Price"),
         yaxis=list(title="Price"))


##################################################################################################
#######################   Recover SPD based on the European option price  ######################################
###############################################################################################
call<-cbind(rep(20000101,length(K)),rep(t*365,length(K)),rep(1,length(K)),K,EO_C,rep(S0,length(K)),rep(67.8,length(K)),rep((r)/365,length(K)),rep(sigma,length(K)))
put<-cbind(rep(20000101,length(K)),rep(t*365,length(K)),rep(0,length(K)),K,EO_P,rep(S0,length(K)),rep(67.8,length(K)),rep((r)/365,length(K)),rep(sigma,length(K)))
OptionTau<-data.frame(rbind(call,put))
colnames(OptionTau)<-c("Date","T","Type","K","EO","S","X","Rf","Vol")

pos <- which( min(abs(OptionTau$K - OptionTau$S)) == abs(OptionTau$K - OptionTau$S))
# find at the money options
obs<- OptionTau[pos,][1,] #use the call; call also use both call and put
ImpVolc <- EuropeanOptionImpliedVolatility("call", value=obs$EO, underlying=obs$S,
                                           strike=obs$K, dividendYield=delta, riskFreeRate=obs$Rf*365, maturity=obs$T/365, volatility=0.2*sqrt(365))[1]
sigma<-ImpVolc

OptionTau$Vol<-sigma

call<-cbind(rep(20000101,length(K)),rep(t*365,length(K)),rep(1,length(K)),K,EO_C,rep(S0,length(K)),rep(67.8,length(K)),rep((r)/365,length(K)),rep(sigma,length(K)))
put<-cbind(rep(20000101,length(K)),rep(t*365,length(K)),rep(0,length(K)),K,EO_P,rep(S0,length(K)),rep(67.8,length(K)),rep((r)/365,length(K)),rep(sigma,length(K)))
OptionTau<-data.frame(rbind(call,put))
colnames(OptionTau)<-c("Date","T","Type","K","EO","S","X","Rf","Vol")

date<-20000101
rnd0<-RND(OptionTau,date)
x<-rnd0[[1]]
beta<-rnd0[[2]]
Ts<-rnd0[[3]]
ST0  <- exp(x*sigma*sqrt(t) + (r)*t + log(S0))

RND_ST0 <- t(Ts) %*% beta / (sigma*sqrt(t)*ST0)

RR0 <- (ST0-S0)/S0
RND_R0 <- RND_ST0*S0

plot_ly(x=~ST0,y=RND_ST0[,1],type='scatter',mode='lines')%>%
  add_lines(x=den$xi[1,],y=den$f[1,],type='scatter',mode='lines')%>%
  layout(xaxis=list(range=c(50,1850)))
  
# remove the European variables to avoid conflicts
rm(OptionTau, sigma, ImpVolc)
sigma<-0

##################################################################################################
#######################   Recover SPD based on the American option price  ######################################
###############################################################################################
# allow the price to be polluted by observation error
err1 <- apply(cbind(-bd*rep(1,length(AO_C)),AO_C*runif(length(AO_C), -ObsErr, ObsErr),bd*rep(1,length(AO_C))),1,median)
err2 <- apply(cbind(-bd*rep(1,length(AO_P)),AO_P*runif(length(AO_P), -ObsErr, ObsErr),bd*rep(1,length(AO_P))),1,median)

AO_C <- AO_C+err1
AO_P <- AO_P+err2

call_AO<-cbind(rep(20000101,length(K)),rep(t*365,length(K)),rep(1,length(K)),K,EO_C,rep(S0,length(K)),AO_C,rep(r/365,length(K)),rep(sigma,length(K)),EEP_C,rep(67.8,length(K)))
put_AO<-cbind(rep(20000101,length(K)),rep(t*365,length(K)),rep(0,length(K)),K,EO_P,rep(S0,length(K)),AO_P,rep(r/365,length(K)),rep(sigma,length(K)),EEP_P,rep(67.8,length(K)))
OptionTau_AO<-data.frame(rbind(call_AO,put_AO))
colnames(OptionTau_AO)<-c("Date","T","Type","K","EO","S","AO","Rf","Vol","EEP","X")

date<-20000101

pos <- which( min(abs(OptionTau_AO$K - OptionTau_AO$S)) == abs(OptionTau_AO$K - OptionTau_AO$S))
# find at the money options
obs<- OptionTau_AO[pos,][1,] #use the call; can also use both call and put
ImpVolc <- AmericanOptionImpliedVolatility("call", value=obs$AO, underlying=obs$S,
                                           strike=obs$K, dividendYield=delta, riskFreeRate=obs$Rf*365, maturity=obs$T/365, volatility=0.2*sqrt(365))[1]
sigma<-ImpVolc

OptionTau_AO$Vol<-sigma

####################################  Initial estimate  ########################################

OptionTau<-data.frame(cbind(OptionTau_AO$Date,OptionTau_AO$T,OptionTau_AO$Type,OptionTau_AO$K,OptionTau_AO$AO,OptionTau_AO$S,OptionTau_AO$X,OptionTau_AO$Rf,OptionTau_AO$Vol))
colnames(OptionTau)<-c("Date","T","Type","K","EO","S","X","Rf","Vol")
rnd<-RND(OptionTau,date)
x<-rnd[[1]]
beta<-rnd[[2]]
Ts<-rnd[[3]]
Sigma<-rnd[[4]]
ST  <- exp(x*sigma*sqrt(t) + (r)*t + log(S0))
RND_ST <- t(Ts) %*% beta / (sigma*sqrt(t)*ST)

RR <- (ST-S0)/S0
RND_R <- RND_ST*S0

plot_ly(x=~ST,y=RND_ST[,1],type='scatter',mode='lines')%>%
  add_lines(x=den$xi[1,],y=den$f[1,],type='scatter',mode='lines')%>%
  layout(xaxis=list(range=c(150,1850)))

########################################  First iteration   ####################################

EE<-EEPC(K,M,x,beta,Ts,sigma,r,delta,Delta,EEP_C,EEP_P)

EEP1P<-EE[[1]]
EEP1C<-EE[[2]]

for (i in 1:length(K)){
  OptionTau_AO$EEP1[i]<-EEP1C[i]
  OptionTau_AO$EEP1[length(K)+i]<-EEP1P[i]
}
OptionTau_AO$EO1<-OptionTau_AO$AO-OptionTau_AO$EEP1

OptionTau<-data.frame(cbind(OptionTau_AO$Date,OptionTau_AO$T,OptionTau_AO$Type,OptionTau_AO$K,OptionTau_AO$EO1,OptionTau_AO$S,OptionTau_AO$X,OptionTau_AO$Rf,OptionTau_AO$Vol))
colnames(OptionTau)<-c("Date","T","Type","K","EO","S","X","Rf","Vol")
rnd1<-RND(OptionTau,date)
x<-rnd1[[1]]
beta<-rnd1[[2]]
Ts<-rnd1[[3]]
ST1  <- exp(x*sigma*sqrt(t) + (r)*t + log(S0))
RND_ST1 <- t(Ts) %*% beta / (sigma*sqrt(t)*ST1)

RR1 <- (ST1-S0)/S0
RND_R1 <- RND_ST1*S0

plot_ly(x=~ST1,y=RND_ST1[,1],type='scatter',mode='lines')%>%
  add_lines(x=~ST0,y=RND_ST0[,1],type='scatter',mode='lines')%>%
  layout(xaxis=list(range=c(250,1550)))

###########################################   Second iteration  #####################################
EE<-EEPC(K,M,x,beta,Ts,sigma,r,delta,Delta,EEP_C,EEP_P)

EEP2P<-EE[[1]]
EEP2C<-EE[[2]]

for (i in 1:length(K)){
  OptionTau_AO$EEP2[i]<-EEP2C[i]
  OptionTau_AO$EEP2[length(K)+i]<-EEP2P[i]
}
OptionTau_AO$EO2<-OptionTau_AO$AO-OptionTau_AO$EEP2

OptionTau<-data.frame(cbind(OptionTau_AO$Date,OptionTau_AO$T,OptionTau_AO$Type,OptionTau_AO$K,OptionTau_AO$EO2,OptionTau_AO$S,OptionTau_AO$X,OptionTau_AO$Rf,OptionTau_AO$Vol))
colnames(OptionTau)<-c("Date","T","Type","K","EO","S","X","Rf","Vol")
rnd2<-RND(OptionTau,date)
x<-rnd2[[1]]
beta<-rnd2[[2]]
Ts<-rnd2[[3]]
ST2  <- exp(x*sigma*sqrt(t) + (r)*t + log(S0))
RND_ST2 <- t(Ts) %*% beta / (sigma*sqrt(t)*ST2)

RR2 <- (ST2-S0)/S0
RND_R2 <- RND_ST2*S0

plot_ly(x=~ST2,y=RND_ST2[,1],type='scatter',mode='lines')%>%
  add_lines(x=~ST0,y=RND_ST0[,1],type='scatter',mode='lines')%>%
  layout(xaxis=list(range=c(150,1850)))

##################################################   Third iteration   ######################################
EE<-EEPC(K,M,x,beta,Ts,sigma,r,delta,Delta,EEP_C,EEP_P)

EEP3P<-EE[[1]]
EEP3C<-EE[[2]]

for (i in 1:length(K)){
  OptionTau_AO$EEP3[i]<-EEP3C[i]
  OptionTau_AO$EEP3[length(K)+i]<-EEP3P[i]
}
OptionTau_AO$EO3<-OptionTau_AO$AO-OptionTau_AO$EEP3

OptionTau<-data.frame(cbind(OptionTau_AO$Date,OptionTau_AO$T,OptionTau_AO$Type,OptionTau_AO$K,OptionTau_AO$EO3,OptionTau_AO$S,OptionTau_AO$X,OptionTau_AO$Rf,OptionTau_AO$Vol))
colnames(OptionTau)<-c("Date","T","Type","K","EO","S","X","Rf","Vol")
rnd3<-RND(OptionTau,date)
x<-rnd3[[1]]
beta<-rnd3[[2]]
Ts<-rnd3[[3]]
ST3  <- exp(x*sigma*sqrt(t) + (r)*t + log(S0))
RND_ST3 <- t(Ts) %*% beta / (sigma*sqrt(t)*ST3)

RR3 <- (ST3-S0)/S0
RND_R3 <- RND_ST3*S0

plot_ly(x=~ST3,y=RND_ST3[,1],type='scatter',mode='lines')%>%
  add_lines(x=~ST0,y=RND_ST0[,1],type='scatter',mode='lines')%>%
  layout(xaxis=list(range=c(150,1850)))

##################################################   Fourth iteration   ######################################
EE<-EEPC(K,M,x,beta,Ts,sigma,r,delta,Delta,EEP_C,EEP_P)

EEP4P<-EE[[1]]
EEP4C<-EE[[2]]

for (i in 1:length(K)){
  OptionTau_AO$EEP4[i]<-EEP4C[i]
  OptionTau_AO$EEP4[length(K)+i]<-EEP4P[i]
}
OptionTau_AO$EO4<-OptionTau_AO$AO-OptionTau_AO$EEP4

OptionTau<-data.frame(cbind(OptionTau_AO$Date,OptionTau_AO$T,OptionTau_AO$Type,OptionTau_AO$K,OptionTau_AO$EO4,OptionTau_AO$S,OptionTau_AO$X,OptionTau_AO$Rf,OptionTau_AO$Vol))
colnames(OptionTau)<-c("Date","T","Type","K","EO","S","X","Rf","Vol")
rnd4<-RND(OptionTau,date)
x<-rnd4[[1]]
beta<-rnd4[[2]]
Ts<-rnd4[[3]]
ST4  <- exp(x*sigma*sqrt(t) + (r)*t + log(S0))
RND_ST4 <- t(Ts) %*% beta / (sigma*sqrt(t)*ST4)

RR4 <- (ST4-S0)/S0
RND_R4 <- RND_ST4*S0

plot_ly(x=~ST4,y=RND_ST4[,1],type='scatter',mode='lines')%>%
  add_lines(x=~ST0,y=RND_ST0[,1],type='scatter',mode='lines')%>%
  layout(xaxis=list(range=c(250,1550)))

 filename<-paste("Figure_A4.pdf",sep="")
 
 
 pdf(file=filename)
 
 par(mfrow = c(2,2))
 
 plot.new()
 
 par(omi=c(0.1,0.1,0.2,0.1))
 
 par(mfcol=c(2, 2))
 
 par(mfg=c(1, 1, 2, 2))
 par(mai=c(0.45, 0.4, 0.5, 0.4))
 
 x1=(den$xi[1,]-S0)/S0
 y1=den$f[1,]*S0
 
 plot(x=RR0,y=RND_R0[,1], type="l", lty=2, lwd=2,xlab="x", ylab="",col="black", xlim=c(-0.5,0.5),ylim=c(0,4))
 lines(x=x1,y=y1, col="red", lty=1, lwd=2)
 mtext("\n(a) SPD estimate based on \n European options", outer=FALSE,adj=0.5,cex=1,line=1)
 
 par(mai=c(0.45, 0.4, 0.5, 0.4))
 par(mfg=c(1, 2, 2, 2))
 
 plot(x=RR,y=RND_R[,1], type="l", lty=2, lwd=2,xlab="x", ylab="",col="black", xlim=c(-0.5,0.5),ylim=c(0,4) )
 lines(x=x1,y=y1, col="red", lty=1, lwd=2)
 mtext("\n(b) Preliminary SPD estimate based on \n American options", outer=FALSE,adj=0.5,cex=1,line=1)
 
 par(mai=c(0.45, 0.4, 0.5, 0.4))
 par(mfg=c(2, 1, 2, 2))
 
 plot(x=RR4,y=RND_R4[,1], type="l", lty=2, lwd=2,xlab="x", ylab="",col="black", xlim=c(-0.5,0.5),ylim=c(0,4) )
 lines(x=x1,y=y1, col="red", lty=1, lwd=2)
 mtext("\n(c) Final SPD estimate based on \n American options", outer=FALSE,adj=0.5,cex=1,line=1)
 
 par(mai=c(0.45, 0.4, 0.5, 0.4))
 par(mfg=c(2, 2, 2, 2))
 
 plot(x=K,y=EEP_P[,1],col="red", lty=1,type="l", lwd=2)
 lines(x=K,y=pmax(EEP_C[,1],0),col="red", lty=1, type="l",lwd=2)
 lines(x=K,y=EEP4P,col="black", lty=2, type="l",lwd=2)
 lines(x=K,y=EEP4C,col="black", lty=2,type="l", lwd=2)
 mtext("\n(d) The true and estimated EEP", outer=FALSE,adj=0.5,cex=1,line=1)
 
 dev.off()
 
 